#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'
require 'rest-client'
require 'net/http'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/feedback'
require_relative '../../pages/landing_notifications'


describe '[Story# VAR-1928: New Appointment - Enter Details]'  do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    @feedback = Feedback.new(@driver)
    @landing_notifications = LandingNotifications.new(@driver)
    TITLE = "Appointments/Requests"

    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
    @nintyDaysLater = getDateNthDaysFromNow(90, "%m/%d/%Y")
    @@patientID ="1113138327"

    #mongo
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "bostonDirectScheduling.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "bostonRequestEligibility.json", @db)
    deletePatientData(@@patientID)
    @common.loginEndsOnHome(pw_redacted)
    @common.selectAddAppointmentButton("VA")

  end

  after(:all) do
    @driver.close
  end

  context 'AC#VAR-2759|TC#VAR-2765: New Appointment - Enter Details criteria' do

    it "Verify Appointment Details form is loaded" do
      @new_appointment.selectTypeOfCare(PRIMARY_CARE)
      @new_appointment.selectState("523")
      @new_appointment.selectSchedulingMethod("direct")
      expect(@new_appointment.appointment_details_legend).to eq("Appointment Details")
    end

    it "should verify labels and options on new appointment form" do
      @new_appointment.selectClinic("32")
      @new_appointment.reason_element.when_present(TIME_OUT_LIMIT)

      expected_content =[\
                        "* required field",
                        "Step 1: Type of Care",
                        "The VA Appointments app supports scheduling specific types of care. If you do not find the care you need, please contact your facility for assistance.",
                        "* Select the type of care you need:",
                        "Select",
                        "Primary Care",
                        "Audiology",
                        "Express Care",
                        "Optometry",
                        "Outpatient Mental Health",
                        "Step 2: City, State",
                        "* Choose the closest city and state for this appointment:",
                        "Select",
                        "Des Moines, IA",
                        "Iowa City, IA",
                        "BOSTON, MA",
                        "Omaha, NE",
                        "Step 3: Location",
                        "One location supports scheduling #{PRIMARY_CARE} through this app. If you cannot find the location you need, please visit the VA Facility Locator to contact the facility for assistance.",
                        "Facility:",
                        "BOSTON HCS VAMC (BOSTON, MA)",
                        "Providers:",
                        "Creamer, Kent",
                        "Your Care Team (PACT)",
                        "Your Care Team (PACT) for BOSTON HCS VAMC",
                        "Step 4: Scheduling Method",
                        "The location you selected supports the following scheduling methods:",
                        "* Select a scheduling method:",
                        "Schedule Myself",
                        "Submit a Request to VA Scheduler",
                        "Appointment Details",
                        "* Select Clinic:",
                        "BO PACT B1",
                        "JP PRIMARY CARE DR. CREAMER",
                        "BO PCC QUICK ACCESS AM 2204",
                        "Primary Care - No Time Slot",
                        "If you don't see the clinic that matches your needs, please contact your facility for assistance.",
                        "* Reason for Appointment:",
                        "(150 char limit)",
                        "150 characters remaining",
                        "* Preferred Date:",
                        "Appointments may be scheduled between " + @tomorrow + " and " +@nintyDaysLater+ ".",
                        "Show Availability",
                        "Email Preferences",
                        "Send me updates on my appointments and requests:",
                        "Information about updates on my appointments and requests",
                        "Yes",
                        "No",
                        "Schedule Appointment Cancel"]


      actual_content = @new_appointment.getScreenContent.split("\n")
      expected_content.each_with_index do | expectedScreenRow, i |
        expect(actual_content[i].strip).to include(expectedScreenRow.strip)
      end

    end


    it "Should verify selecting clinic loads Reason for Appointment and preferred dates options" do

      @new_appointment.reason_element.when_present(TIME_OUT_LIMIT)
      @new_appointment.preferred_date_element.when_present(TIME_OUT_LIMIT)
      expect(@new_appointment.reason_element.present?).to eq(true)
      expect(@new_appointment.preferred_date_element.present?).to eq(true)
    end
  end
end








